<?php
session_start();
if (!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit();
}

include_once 'config.php';

// درخواست‌های کاربران معمولی (خرید)
$normalSells = $conn->query("SELECT * FROM sells WHERE status = 'pending' AND is_colleague = 0");

// درخواست‌های همکارها (خرید)
$colleagueSells = $conn->query("SELECT * FROM sells WHERE status = 'pending' AND is_colleague = 1");
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>ملک‌های خرید</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <style>
        .colleague-table th { background-color: #d4edda; } /* رنگ سبز روشن برای جدول همکارها */
        h2 { margin-top: 20px; color: #333; }
        table { margin-bottom: 30px; }
    </style>
</head>
<body>
    <div class="container">
        <h1>ملک‌های خرید در انتظار</h1>

        <h2>درخواست‌های کاربران معمولی</h2>
        <table>
            <thead>
                <tr>
                    <th>شناسه</th>
                    <th>نوع</th>
                    <th>متراژ</th>
                    <th>کاربری</th>
                    <th>اقدامات</th>
                </tr>
            </thead>
            <tbody>
                <?php while ($row = $normalSells->fetch_assoc()): ?>
                <tr>
                    <td><?php echo $row['id']; ?></td>
                    <td>فروش</td>
                    <td><?php echo $row['meterage']; ?></td>
                    <td><?php echo $row['type']; ?></td>
                    <td>
                        <a href="approve.php?type=sell&id=<?php echo $row['id']; ?>&chatid=<?php echo $row['chatid']; ?>" class="btn approve">تأیید</a>
                        <a href="decline.php?type=sell&id=<?php echo $row['id']; ?>&chatid=<?php echo $row['chatid']; ?>" class="btn decline">رد</a>
                    </td>
                </tr>
                <?php endwhile; ?>
            </tbody>
        </table>

        <h2>درخواست‌های همکارها</h2>
        <table class="colleague-table">
            <thead>
                <tr>
                    <th>شناسه</th>
                    <th>نوع</th>
                    <th>متراژ</th>
                    <th>کاربری</th>
                    <th>اقدامات</th>
                </tr>
            </thead>
            <tbody>
                <?php while ($row = $colleagueSells->fetch_assoc()): ?>
                <tr>
                    <td><?php echo $row['id']; ?></td>
                    <td>فروش</td>
                    <td><?php echo $row['meterage']; ?></td>
                    <td><?php echo $row['type']; ?></td>
                    <td>
                        <a href="approve.php?type=sell&id=<?php echo $row['id']; ?>&chatid=<?php echo $row['chatid']; ?>" class="btn approve">تأیید</a>
                        <a href="decline.php?type=sell&id=<?php echo $row['id']; ?>&chatid=<?php echo $row['chatid']; ?>" class="btn decline">رد</a>
                    </td>
                </tr>
                <?php endwhile; ?>
            </tbody>
        </table>

        <a href="index.php" class="logout">بازگشت به پنل اصلی</a>
    </div>
</body>
</html>